<?php
session_start();
include "../connection.php"; 


if (!isset($_SESSION['userid'])) {
    // Check if the cookie exists
    if (isset($_COOKIE['userid'])) {
        $_SESSION['userid'] = $_COOKIE['userid'];
    } else {
        header("Location: ../login.php");
        exit();
    }
}

$userid = $_SESSION['userid'];
$gateway = $_POST['gateway'];
$taka = $_POST['Taka'];
$name = $_POST['Name'];
$number = $_POST['Number'];
$date = date('Y-m-d'); // Current date and time
$status = 'Pending';

// Prepare the SQL statement to insert into the balance history
$sqlInsertHistory = "INSERT INTO balance_history (userid,gateway, taka, name, number, date, status)
										  VALUES (?,?, ?, ?, ?, ?, ?)";
$stmtInsertHistory = $con->prepare($sqlInsertHistory);
$stmtInsertHistory->bind_param("issssss", $userid,$gateway, $taka, $name, $number, $date, $status);

if ($stmtInsertHistory->execute()) {
    // Success message
    $_SESSION['message'] = " রিকোয়েস্ট সফল হয়েছে ";
} else {
    // Error message
    $_SESSION['message'] = " দু:খিত! পুনরায় চেষ্টা করুন ";
}

// Close connection
$stmtInsertHistory->close();
$con->close();

// Redirect to index.php
header("Location: index.php");
exit();
?>
